Imports Drawing

Public Class Form1
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub
  Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
  Friend WithEvents ContextMenu1 As System.Windows.Forms.ContextMenu
  Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem4 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItemRectangle As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItemTriangle As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItemEllipse As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem7 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItemDraw As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItemHelp As System.Windows.Forms.MenuItem

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.MainMenu1 = New System.Windows.Forms.MainMenu()
    Me.MenuItem1 = New System.Windows.Forms.MenuItem()
    Me.MenuItem4 = New System.Windows.Forms.MenuItem()
    Me.MenuItem2 = New System.Windows.Forms.MenuItem()
    Me.MenuItemDraw = New System.Windows.Forms.MenuItem()
    Me.MenuItemRectangle = New System.Windows.Forms.MenuItem()
    Me.MenuItemEllipse = New System.Windows.Forms.MenuItem()
    Me.MenuItemTriangle = New System.Windows.Forms.MenuItem()
    Me.MenuItemHelp = New System.Windows.Forms.MenuItem()
    Me.ContextMenu1 = New System.Windows.Forms.ContextMenu()
    Me.MenuItem7 = New System.Windows.Forms.MenuItem()
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1, Me.MenuItem2, Me.MenuItemHelp})
    '
    'MenuItem1
    '
    Me.MenuItem1.Index = 0
    Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem4})
    Me.MenuItem1.Text = "&File"
    '
    'MenuItem4
    '
    Me.MenuItem4.Index = 0
    Me.MenuItem4.Text = "Exit"
    '
    'MenuItem2
    '
    Me.MenuItem2.Index = 1
    Me.MenuItem2.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItemDraw})
    Me.MenuItem2.Text = "&Tools"
    '
    'MenuItemDraw
    '
    Me.MenuItemDraw.Index = 0
    Me.MenuItemDraw.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItemRectangle, Me.MenuItemEllipse, Me.MenuItemTriangle})
    Me.MenuItemDraw.Text = "&Draw"
    '
    'MenuItemRectangle
    '
    Me.MenuItemRectangle.Index = 0
    Me.MenuItemRectangle.OwnerDraw = True
    Me.MenuItemRectangle.Text = "Rectangle"
    '
    'MenuItemEllipse
    '
    Me.MenuItemEllipse.Index = 1
    Me.MenuItemEllipse.OwnerDraw = True
    Me.MenuItemEllipse.Text = "Ellipse"
    '
    'MenuItemTriangle
    '
    Me.MenuItemTriangle.Index = 2
    Me.MenuItemTriangle.OwnerDraw = True
    Me.MenuItemTriangle.Text = "Triangle"
    '
    'MenuItemHelp
    '
    Me.MenuItemHelp.Index = 2
    Me.MenuItemHelp.Text = "&Help"
    '
    'ContextMenu1
    '
    Me.ContextMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem7})
    '
    'MenuItem7
    '
    Me.MenuItem7.Index = 0
    Me.MenuItem7.Text = "&Triangle"
    '
    'Form1
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(16, 38)
    Me.AutoScroll = True
    Me.ClientSize = New System.Drawing.Size(448, 359)
    Me.Font = New System.Drawing.Font("Microsoft Sans Serif", 20.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Menu = Me.MainMenu1
    Me.Name = "Form1"
    Me.Text = "Menu Demo Application"

  End Sub

#End Region

  Private Sub MenuItem4_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuItem4.Click
    Application.Exit()
  End Sub


  Private Sub MenuItemRectangle_DrawItem(ByVal sender As Object, _
    ByVal e As System.Windows.Forms.DrawItemEventArgs) _
    Handles MenuItemRectangle.DrawItem

    e.DrawBackground()
    Dim R As Rectangle = e.Bounds
    R.Inflate(-3, -4)
    e.Graphics.DrawRectangle(Pens.Red, R)

  End Sub

  Private Sub MenuItemRectangle_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItemRectangle.Click
    CreateGraphics.DrawRectangle(Pens.Black, New Rectangle(50, 50, 50, 100))
  End Sub

  Private Sub MenuItemRectangle_MeasureItem(ByVal sender As Object, _
    ByVal e As System.Windows.Forms.MeasureItemEventArgs) _
    Handles MenuItemRectangle.MeasureItem

    e.ItemHeight = 20
    e.ItemWidth = 60
  End Sub

  Private Sub MenuItemTriangle_MeasureItem(ByVal sender As Object, _
    ByVal e As System.Windows.Forms.MeasureItemEventArgs) Handles MenuItemTriangle.MeasureItem
    e.ItemHeight = 20
    e.ItemWidth = 60
  End Sub

  Private Sub MenuItemEllipse_DrawItem(ByVal sender As Object, _
    ByVal e As System.Windows.Forms.DrawItemEventArgs) Handles MenuItemEllipse.DrawItem

    Text = e.State.ToString & " " & CType(sender, MenuItem).Text
    e.DrawBackground()
    Dim R As Rectangle = e.Bounds
    R.Inflate(-3, -3)
    e.Graphics.DrawEllipse(Pens.Orange, R)

  End Sub

  Private Sub MenuItemEllipse_MeasureItem(ByVal sender As Object, _
    ByVal e As System.Windows.Forms.MeasureItemEventArgs) Handles MenuItemEllipse.MeasureItem
    e.ItemHeight = 20
    e.ItemWidth = 60
  End Sub

  Private Sub MenuItemEllipse_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuItemEllipse.Click
    CreateGraphics.DrawEllipse(Pens.Blue, New Rectangle(50, 50, 50, 100))
  End Sub

  Private Sub MenuItemTriangle_DrawItem(ByVal sender As Object, _
    ByVal e As System.Windows.Forms.DrawItemEventArgs) Handles MenuItemTriangle.DrawItem

    e.DrawBackground()

    Text = e.State.ToString & " " & CType(sender, MenuItem).Text
    DrawTriangle(e.Graphics, e.Bounds)

  End Sub

  Private Sub DrawTriangle(ByVal G As Graphics, ByVal Rect As Rectangle)

    Dim p1 As New Point(Rect.X + Rect.Width / 2, Rect.Y)
    Dim p2 As New Point(Rect.X + 2, Rect.Y + Rect.Height - 2)
    Dim P3 As New Point(Rect.X + Rect.Width - 2, Rect.Y + Rect.Height - 2)
    Dim Points() As Point = {p1, p2, P3}
    G.DrawPolygon(Pens.Yellow, Points)

  End Sub

  Private Sub MenuItemTriangle_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuItemTriangle.Click
    DrawTriangle(CreateGraphics, New Rectangle(50, 50, 50, 100))
  End Sub

  Private Sub DoClick(ByVal sender As Object, _
    ByVal e As System.EventArgs)

    If (FPlug Is Nothing) Then Exit Sub
    FPlug.Draw(CreateGraphics(), _
      New Rectangle(100, 100, 50, 100))

  End Sub

  Private FPlug As PluggableShape

  Private Sub Plugin(ByVal Plug As Drawing.PluggableShape)
    Try
      FPlug = Plug
      MenuItemDraw.MenuItems.Add( _
        FPlug.GetMenuItem(AddressOf DoClick))
    Catch
      FPlug = Nothing
    End Try
  End Sub

  Private Sub DoABout(ByVal sender As Object, _
    ByVal e As System.EventArgs)

    Const Message As String = _
        "Demonstracja Menu" & vbCrLf & _
        "Helion, VB .NET Ksiga eksperta" & vbCrLf & _
        "Autor: Paul Kimmel. Copyright (c) 2001."


    MsgBox(Message, MsgBoxStyle.Information, "About")

  End Sub

  Private Sub Form1_Load(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MyBase.Load

    Dim About As New MenuItem("O programie...")
    AddHandler About.Click, AddressOf DoABout
    MenuItemHelp.MenuItems.Add(About)

    Plugin(New AdvancedShape())

  End Sub
End Class
